/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.factories;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import technology.rocketjump.undermount.assets.FloorDictionary;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.entities.EntityStore;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesType;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.jobs.model.Profession;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapping.factories.GameMapConverter;
import technology.rocketjump.undermount.mapping.factories.MapGenWrapper;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.RoomPlacementMessage;
import technology.rocketjump.undermount.rooms.RoomTile;
import technology.rocketjump.undermount.rooms.RoomTypeDictionary;

public class TiledMapFactory {
    private final MapGenWrapper mapGenWrapper;
    private final GameMapConverter gameMapConverter;
    private final ItemTypeDictionary itemTypeDictionary;
    private final GameMaterialDictionary materialDictionary;
    private final FloorType baseFloor;
    private final GameMaterial baseFloorMaterial;
    private final PlantSpeciesDictionary plantSpeciesDictionary;
    private final RoomTypeDictionary roomTypeDictionary;

    @Inject
    public TiledMapFactory(MapGenWrapper mapGenWrapper, ItemTypeDictionary itemTypeDictionary, GameMaterialDictionary gameMaterialDictionary, FloorDictionary floorDictionary, GameMapConverter gameMapConverter, PlantSpeciesDictionary plantSpeciesDictionary, RoomTypeDictionary roomTypeDictionary) {
        this.mapGenWrapper = mapGenWrapper;
        this.itemTypeDictionary = itemTypeDictionary;
        this.materialDictionary = gameMaterialDictionary;
        this.baseFloor = floorDictionary.getByFloorTypeName("rough_stone");
        this.gameMapConverter = gameMapConverter;
        this.plantSpeciesDictionary = plantSpeciesDictionary;
        this.roomTypeDictionary = roomTypeDictionary;
        this.baseFloorMaterial = this.materialDictionary.getByName("Granite");
    }

    public TiledMap create(long worldSeed, int worldWidth, int worldHeight, EntityStore newEntityStore) {
        GameMap mapGenGameMap = this.mapGenWrapper.createUsingLibrary(worldSeed, worldWidth, worldHeight);
        TiledMap areaMap = new TiledMap(worldSeed, worldWidth, worldHeight, this.baseFloor, this.baseFloorMaterial);
        this.gameMapConverter.apply(mapGenGameMap, areaMap, worldSeed, newEntityStore);
        return areaMap;
    }

    public void postInitStep(GameContext gameContext, MessageDispatcher messageDispatcher, List<Profession> professionList) {
        TiledMap areaMap = gameContext.getAreaMap();
        GridPoint2 embarkPoint = areaMap.getEmbarkPoint();
        for (Profession profession : professionList) {
            this.addEntity(embarkPoint.x, embarkPoint.y, gameContext, profession);
        }
        ItemType plankItemType = this.itemTypeDictionary.getByName("Resource-Planks");
        GameMaterial plankMaterialType = this.pickWoodMaterialType();
        ItemType stoneBlockItemType = this.itemTypeDictionary.getByName("Resource-Stone-Block");
        GameMaterial stoneBlockMaterialType = this.pickMaterialType(stoneBlockItemType);
        ItemType metalItemType = this.itemTypeDictionary.getByName("Resource-Metal-Ingot");
        GameMaterial metalMaterial = this.pickMaterialType(metalItemType);
        HashMap<GridPoint2, RoomTile> roomTiles = new HashMap<GridPoint2, RoomTile>();
        this.createResources(embarkPoint.x - 1, embarkPoint.y - 1, plankItemType, plankMaterialType, gameContext, messageDispatcher, roomTiles);
        this.createResources(embarkPoint.x - 1, embarkPoint.y, plankItemType, plankMaterialType, gameContext, messageDispatcher, roomTiles);
        this.createResources(embarkPoint.x - 1, embarkPoint.y + 1, plankItemType, plankMaterialType, gameContext, messageDispatcher, roomTiles);
        this.createResources(embarkPoint.x, embarkPoint.y - 1, stoneBlockItemType, stoneBlockMaterialType, gameContext, messageDispatcher, roomTiles);
        this.createResources(embarkPoint.x, embarkPoint.y, stoneBlockItemType, stoneBlockMaterialType, gameContext, messageDispatcher, roomTiles);
        this.createResources(embarkPoint.x, embarkPoint.y + 1, stoneBlockItemType, stoneBlockMaterialType, gameContext, messageDispatcher, roomTiles);
        this.createResources(embarkPoint.x + 1, embarkPoint.y - 1, metalItemType, metalMaterial, gameContext, messageDispatcher, roomTiles);
        this.createResources(embarkPoint.x + 1, embarkPoint.y, metalItemType, metalMaterial, gameContext, messageDispatcher, roomTiles);
        this.createResources(embarkPoint.x + 1, embarkPoint.y + 1, metalItemType, metalMaterial, gameContext, messageDispatcher, roomTiles);
        RoomPlacementMessage message = new RoomPlacementMessage(roomTiles, this.roomTypeDictionary.getByName("STOCKPILE"));
        messageDispatcher.dispatchMessage(249, message);
    }

    private void addEntity(int tileX, int tileY, GameContext gameContext, Profession profession) {
        Random random = new Random();
        Vector2 worldPosition = new Vector2((float)tileX + 0.5f + (0.1f - random.nextFloat() * 0.2f), (float)tileY + 0.5f + (0.1f - random.nextFloat() * 0.2f));
        Vector2 facing = new Vector2(random.nextFloat() * 2.0f - 1.0f, random.nextFloat() * 2.0f - 1.0f);
        gameContext.getEntityStore().createHumanoid(worldPosition, facing, gameContext.getAreaMap(), profession);
    }

    private void createResources(int x, int y, ItemType itemType, GameMaterial materialToUse, GameContext gameContext, MessageDispatcher messageDispatcher, Map<GridPoint2, RoomTile> roomTiles) {
        TiledMap areaMap = gameContext.getAreaMap();
        MapTile tile = areaMap.getTile(x, y);
        if (tile.hasWall()) {
            messageDispatcher.dispatchMessage(606, tile.getTilePosition());
        }
        LinkedList<Long> entitiesToRemove = new LinkedList<Long>();
        for (Entity entity : tile.getEntities()) {
            if (entity.getType().equals((Object)EntityType.HUMANOID)) continue;
            entitiesToRemove.add(entity.getId());
        }
        for (Long entityId : entitiesToRemove) {
            gameContext.getEntityStore().remove(entityId);
            tile.removeEntity(entityId);
        }
        ItemEntityAttributes itemEntityAttributes = new ItemEntityAttributes(gameContext.getRandom().nextLong());
        itemEntityAttributes.setItemType(itemType);
        itemEntityAttributes.setMaterial(materialToUse);
        itemEntityAttributes.setQuantity(itemType.getMaxStackSize());
        GridPoint2 location = new GridPoint2(x, y);
        gameContext.getEntityStore().createResourceItem(itemEntityAttributes, location, gameContext.getAreaMap());
        RoomTile roomTile = new RoomTile();
        roomTile.setTile(gameContext.getAreaMap().getTile(location));
        roomTile.setTilePosition(location);
        roomTiles.put(location, roomTile);
    }

    private GameMaterial pickWoodMaterialType() {
        ArrayList<PlantSpecies> treeSpecies = new ArrayList<PlantSpecies>();
        for (PlantSpecies plantSpecies : this.plantSpeciesDictionary.getAll()) {
            if (!plantSpecies.getPlantType().equals((Object)PlantSpeciesType.TREE)) continue;
            treeSpecies.add(plantSpecies);
        }
        return ((PlantSpecies)treeSpecies.get(MathUtils.random.nextInt(treeSpecies.size()))).getBranchMaterial();
    }

    private GameMaterial pickMaterialType(ItemType itemType) {
        List<GameMaterial> materials = this.materialDictionary.getByType(itemType.getPrimaryMaterialType());
        return materials.get(MathUtils.random.nextInt(materials.size()));
    }
}

